 
 
local function GetFormattedPlayerModel(PlyModel)
	return PlyModel:sub(8, PlyModel:len() - 4)
end
hook.Add("PlayerDeathSound", "KingpinPlayerDeathSoundBlocker", function(Ply, ...)

	local PlyModel = GetFormattedPlayerModel(Ply:GetModel())
	return (GetConVarNumber("kp_hurtsounds") == 1 and (PlyModel == "thug" or PlyModel == "runt" or PlyModel == "chick")) and true or nil
end)
hook.Add("PlayerDeath", "KingpinPlayerDeath", function(Ply, Inflictor, Attacker)
	if GetConVarNumber("kp_hurtsounds") == 1 and IsValid(Ply) then
		local PlyModel = GetFormattedPlayerModel(Ply:GetModel())
		local DeathType = Ply:IsOnFire() and "flamedeath" or "death"
		if PlyModel == "thug" or PlyModel == "runt" then
			Ply:EmitSound("kp/male/" ..DeathType .. math.random(1, 4).. ".wav")
		elseif PlyModel == "chick" then
			Ply:EmitSound("kp/female/" ..DeathType .. math.random(1, 4).. ".wav")
		end
	end
end)
hook.Add("PlayerHurt", "KingpinPlayerHurt", function(Ply, Attacker, Health, Damage)
	if GetConVarNumber("kp_hurtsounds") == 1 and Health > 0 and IsValid(Ply) and Damage > 1 and (Ply.kp_HurtSoundDelay or 0) <= CurTime() then
		Ply.kp_HurtSoundDelay = CurTime() + 0.4
		local HealthQuart = math.ceil(math.Clamp(Health, 1, 100) / 25) * 25
		local PlyModel = GetFormattedPlayerModel(Ply:GetModel())
		if PlyModel == "thug" or PlyModel == "runt" then
			Ply:EmitSound("kp/male/pain" ..HealthQuart.. "_" ..math.random(1, 2).. ".wav")
		elseif PlyModel == "chick" then
			Ply:EmitSound("kp/female/pain" ..HealthQuart.. "_" ..math.random(1, 2).. ".wav")
		end
	end
end)
hook.Add("SetupMove", "KingpinJumpSound", function(Ply, Move)
	if GetConVarNumber("kp_jumpsound") == 1 and IsValid(Ply) and Ply:Health() > 0 and Ply:OnGround() and bit.band(Move:GetButtons(), IN_JUMP) ~= 0 and bit.band(Move:GetOldButtons(), IN_JUMP) == 0 and (Ply.kp_JumpSoundDelay or 0) <= CurTime() then
		Ply.kp_JumpSoundDelay = CurTime() + 0.18
		local PlyModel = GetFormattedPlayerModel(Ply:GetModel())
		if PlyModel == "thug" or PlyModel == "runt" then
			Ply:EmitSound("kp/male/jump" ..math.random(1, 3).. ".wav")
		elseif PlyModel == "chick" then
			Ply:EmitSound("kp/female/jump" ..math.random(1, 3).. ".wav")
		end
	end
end)